/*
 * Decompiled with CFR 0.152.
 */
package com.gprinter.io;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Bitmap;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbManager;
import android.support.annotation.RequiresApi;
import android.text.TextUtils;
import android.util.Log;
import com.gprinter.bean.PrinterDevices;
import com.gprinter.io.PortManager;
import com.gprinter.utils.CallbackListener;
import com.gprinter.utils.Command;
import com.gprinter.utils.GpUtils;
import com.gprinter.utils.LogUtils;
import com.gprinter.utils.PDFUtils;
import com.gprinter.utils.SDKUtils;
import com.gprinter.utils.UIThreadManager;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

public class UsbPort
extends PortManager {
    private static final String TAG = UsbPort.class.getSimpleName();
    private static final String ACTION_USB_PERMISSION = "com.android.example.USB_PERMISSION";
    private UsbDevice mUsbDevice;
    private UsbManager usbManager;
    private Context mContext;
    private UsbDeviceConnection mmConnection;
    private UsbInterface mmIntf;
    private UsbEndpoint mmEndIn;
    private UsbEndpoint mmEndOut;
    private int SPLITE_SIZE = 64;
    private boolean isConn = false;
    private Command command = null;
    private CallbackListener callbackListener;
    private PrinterDevices mPrinterDevices = null;
    private final Object lock = new Object();
    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
    private byte[] buffer = new byte[128];
    private IoReader reader = null;
    private BroadcastReceiver mUsbReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            Log.d((String)((Object)((Object)this)).getClass().getName(), (String)action);
            if (UsbPort.ACTION_USB_PERMISSION.equals(action)) {
                1 var4_4 = this;
                synchronized (var4_4) {
                    UsbDevice device = (UsbDevice)intent.getParcelableExtra("device");
                    UsbPort.this.mUsbDevice = device;
                    if (intent.getBooleanExtra("permission", false)) {
                        Log.e((String)TAG, (String)"Allow USB Permission");
                        new Thread(new Runnable(){

                            @Override
                            public void run() {
                                UsbPort.this.openPort();
                            }
                        }).start();
                    } else {
                        Log.e((String)TAG, (String)"permission denied for accessory ");
                        UsbPort.this.setFailureListen();
                    }
                }
            } else if ("android.hardware.usb.action.USB_DEVICE_DETACHED".equals(action)) {
                Log.e((String)TAG, (String)"USB Device Detached");
                UsbDevice usbDevice = (UsbDevice)intent.getParcelableExtra("device");
                if (usbDevice.equals((Object)UsbPort.this.mUsbDevice) && UsbPort.this.callbackListener != null) {
                    UIThreadManager.onUIThread(new Runnable(){

                        @Override
                        public void run() {
                            UsbPort.this.callbackListener.onDisconnect();
                        }
                    });
                }
            }
        }
    };
    private PendingIntent mPermissionIntent;

    public UsbPort(PrinterDevices devices) {
        if (devices != null) {
            this.mPrinterDevices = devices;
            this.mContext = devices.getContext();
            this.mUsbDevice = devices.getUsbDevice();
            this.callbackListener = devices.getCallbackListener();
            this.command = devices.getCommand();
            this.registerReceiver(this.mContext);
        }
    }

    private void registerReceiver(Context context) {
        try {
            IntentFilter filter = new IntentFilter();
            filter.addAction(ACTION_USB_PERMISSION);
            filter.addAction("android.hardware.usb.action.USB_DEVICE_DETACHED");
            context.registerReceiver(this.mUsbReceiver, filter);
        }
        catch (Exception e) {
            LogUtils.e(e.getMessage());
        }
    }

    public UsbPort(Context context, int pid, int vid, CallbackListener callbackListener, Command command) {
        this.mContext = context;
        this.callbackListener = callbackListener;
        this.command = command;
        this.usbManager = (UsbManager)context.getSystemService("usb");
        HashMap deviceList = this.usbManager.getDeviceList();
        for (UsbDevice usbDevice : deviceList.values()) {
            if (usbDevice.getVendorId() != vid || usbDevice.getProductId() != pid) continue;
            this.mUsbDevice = usbDevice;
            break;
        }
    }

    @Override
    public boolean openPort() {
        if (this.usbManager == null) {
            this.usbManager = (UsbManager)this.mContext.getSystemService("usb");
        }
        if (this.mUsbDevice != null) {
            if (this.callbackListener != null) {
                UIThreadManager.onUIThread(new Runnable(){

                    @Override
                    public void run() {
                        UsbPort.this.callbackListener.onConnecting();
                    }
                });
            }
            if (!this.usbManager.hasPermission(this.mUsbDevice)) {
                Log.e((String)TAG, (String)"USB is not permission");
                this.mPermissionIntent = PendingIntent.getBroadcast((Context)this.mContext, (int)0, (Intent)new Intent(ACTION_USB_PERMISSION), (int)0);
                this.usbManager.requestPermission(this.mUsbDevice, this.mPermissionIntent);
            } else {
                UsbInterface usbInterface;
                int i;
                int count = this.mUsbDevice.getInterfaceCount();
                UsbInterface intf = null;
                for (i = 0; i < count && (intf = (usbInterface = this.mUsbDevice.getInterface(i))).getInterfaceClass() != 7; ++i) {
                }
                if (intf != null) {
                    this.mmIntf = intf;
                    this.mmConnection = null;
                    this.mmConnection = this.usbManager.openDevice(this.mUsbDevice);
                    if (this.mmConnection != null && this.mmConnection.claimInterface(intf, true)) {
                        for (i = 0; i < intf.getEndpointCount(); ++i) {
                            UsbEndpoint ep = intf.getEndpoint(i);
                            if (ep.getType() != 2) continue;
                            if (ep.getDirection() == 0) {
                                this.mmEndOut = ep;
                                continue;
                            }
                            this.mmEndIn = ep;
                        }
                    }
                }
                if (this.mmEndOut != null && this.mmEndIn != null) {
                    try {
                        if (this.command == null) {
                            this.checkPrinterCommand();
                        } else if (this.callbackListener != null) {
                            UIThreadManager.onUIThread(new Runnable(){

                                @Override
                                public void run() {
                                    UsbPort.this.callbackListener.onSuccess(UsbPort.this.mPrinterDevices);
                                }
                            });
                        }
                    }
                    catch (IOException e) {
                        this.setFailureListen();
                    }
                    this.reader = new IoReader();
                    this.reader.start();
                    this.isConn = true;
                    return true;
                }
                this.setFailureListen();
            }
        } else {
            Log.e((String)TAG, (String)"USB devices is null");
            this.setFailureListen();
        }
        return false;
    }

    private void checkPrinterCommand() throws IOException {
        int status = -1;
        status = this.getPrinterStatus(Command.ESC);
        if (status == -1) {
            status = this.getPrinterStatus(Command.CPCL);
            if (status == -1) {
                status = this.getPrinterStatus(Command.TSC);
                if (status == -1) {
                    this.setFailureListen();
                } else {
                    this.setSuccessListen(Command.TSC);
                }
            } else {
                this.setSuccessListen(Command.CPCL);
            }
        } else {
            this.setSuccessListen(Command.ESC);
        }
    }

    @Override
    public void setCommand(Command command) {
        this.command = command;
    }

    @Override
    public PrinterDevices getPrinterDevices() {
        return this.mPrinterDevices;
    }

    @Override
    public Command getCommand() {
        return this.command;
    }

    private void setSuccessListen(Command command) {
        this.command = command;
        this.mPrinterDevices.setCommand(command);
        if (this.callbackListener != null) {
            UIThreadManager.onUIThread(new Runnable(){

                @Override
                public void run() {
                    UsbPort.this.callbackListener.onSuccess(UsbPort.this.mPrinterDevices);
                }
            });
        }
    }

    private void setFailureListen() {
        if (this.callbackListener != null) {
            UIThreadManager.onUIThread(new Runnable(){

                @Override
                public void run() {
                    UsbPort.this.callbackListener.onFailure();
                }
            });
        }
    }

    public UsbDevice getmUsbDevice() {
        return this.mUsbDevice;
    }

    @Override
    @RequiresApi(api=21)
    public boolean writePDFToEsc(File file, int width) throws Exception {
        Bitmap[] bitmaps = PDFUtils.PDFToBitmap(file, width);
        if (bitmaps == null) {
            return false;
        }
        for (int i = 0; i < bitmaps.length; ++i) {
            byte[] data = PDFUtils.drawEscPDF(bitmaps[i]);
            this.writeDataImmediately(data);
            if (i != bitmaps.length - 1) continue;
            return true;
        }
        byte[] command = new byte[]{10, 29, 86, 66, 0, 27, 64};
        this.writeDataImmediately(command);
        return false;
    }

    @Override
    @RequiresApi(api=21)
    public boolean writePDFToTsc(File file, int printWidth, int gap, boolean cut, boolean dpi200, boolean compression, int cutHeight) throws Exception {
        if (file == null) {
            throw new Exception("File cannot be empty");
        }
        if (TextUtils.isEmpty((CharSequence)String.valueOf(printWidth))) {
            throw new Exception("printWidth cannot be empty");
        }
        if (TextUtils.isEmpty((CharSequence)String.valueOf(gap))) {
            throw new Exception("gap cannot be empty");
        }
        if (TextUtils.isEmpty((CharSequence)String.valueOf(cutHeight))) {
            throw new Exception("cutHeight cannot be empty");
        }
        Bitmap[] bitmaps = PDFUtils.PDFToBitmap(file, printWidth);
        if (bitmaps == null) {
            return false;
        }
        if (gap > 0 | cutHeight == 0) {
            for (int i = 0; i < bitmaps.length; ++i) {
                byte[] data;
                String size = "\r\nSIZE " + bitmaps[i].getWidth() / (dpi200 ? 8 : 12) + " mm," + bitmaps[i].getHeight() / (dpi200 ? 8 : 12) + " mm\r\n";
                this.writeDataImmediately(size.getBytes("GB18030"));
                String GAP = "GAP " + gap + " mm,0 mm\r\n";
                if (cut && i == bitmaps.length - 1) {
                    this.writeDataImmediately("SET CUTTER 1\r\n".getBytes("GB18030"));
                } else {
                    this.writeDataImmediately("SET CUTTER OFF\r\n".getBytes("GB18030"));
                }
                this.writeDataImmediately(GAP.getBytes("GB18030"));
                String cls = "CLS\r\n";
                this.writeDataImmediately(cls.getBytes("GB18030"));
                if (compression) {
                    data = PDFUtils.drawTscPDFLib(bitmaps[i]);
                    this.writeDataImmediately(data);
                } else {
                    data = PDFUtils.drawTscPDF(bitmaps[i]);
                    this.writeDataImmediately(data);
                }
                String print = "\r\nPRINT 1\r\n";
                this.writeDataImmediately(print.getBytes("GB18030"));
                if (i != bitmaps.length - 1) continue;
                return true;
            }
        } else {
            for (int i = 0; i < bitmaps.length; ++i) {
                List<Bitmap> mlist = UsbPort.ImageCrop(bitmaps[i], cutHeight);
                for (int j = 0; j < mlist.size(); ++j) {
                    byte[] data;
                    String size = "\r\nSIZE " + mlist.get(j).getWidth() / (dpi200 ? 8 : 12) + " mm," + mlist.get(j).getHeight() / (dpi200 ? 8 : 12) + " mm\r\n";
                    this.writeDataImmediately(size.getBytes("GB18030"));
                    String GAP = "GAP 0 mm,0 mm\r\n";
                    if (cut && j == mlist.size() - 1 && i == bitmaps.length - 1) {
                        this.writeDataImmediately("SET CUTTER 1\r\n".getBytes("GB18030"));
                    } else {
                        this.writeDataImmediately("SET CUTTER OFF\r\n".getBytes("GB18030"));
                    }
                    this.writeDataImmediately(GAP.getBytes("GB18030"));
                    String cls = "CLS\r\n";
                    this.writeDataImmediately(cls.getBytes("GB18030"));
                    if (compression) {
                        data = PDFUtils.drawTscPDFLib(mlist.get(j));
                        this.writeDataImmediately(data);
                    } else {
                        data = PDFUtils.drawTscPDF(mlist.get(j));
                        this.writeDataImmediately(data);
                    }
                    String print = "\r\nPRINT 1\r\n";
                    this.writeDataImmediately(print.getBytes("GB18030"));
                }
                if (i != bitmaps.length - 1) continue;
                mlist.clear();
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean writeBitmapToTsc(Bitmap mBitmap, int printWidth, boolean cut, boolean dpi200, boolean compression, int cutHeight) throws Exception {
        if (mBitmap == null) {
            throw new Exception("Bitmap cannot be empty");
        }
        if (TextUtils.isEmpty((CharSequence)String.valueOf(printWidth))) {
            throw new Exception("printWidth cannot be empty");
        }
        if (TextUtils.isEmpty((CharSequence)String.valueOf(cutHeight))) {
            throw new Exception("cutHeight cannot be empty");
        }
        if (mBitmap != null) {
            int width = (printWidth + 7) / 8 * 8;
            int height = mBitmap.getHeight() * width / mBitmap.getWidth();
            Log.d((String)"BMP", (String)("bmp.getWidth() " + mBitmap.getWidth()));
            Bitmap rszBitmap = GpUtils.resizeImage(mBitmap, width, height);
            List<Bitmap> mlist = UsbPort.ImageCrop(rszBitmap, cutHeight);
            for (int j = 0; j < mlist.size(); ++j) {
                String size = "\r\nSIZE " + mlist.get(j).getWidth() / (dpi200 ? 8 : 12) + " mm," + mlist.get(j).getHeight() / (dpi200 ? 8 : 12) + " mm\r\n";
                this.writeDataImmediately(size.getBytes("GB18030"));
                String gap = "GAP 0 mm,0 mm\r\n";
                this.writeDataImmediately(gap.getBytes("GB18030"));
                if (cut && j == mlist.size() - 1) {
                    this.writeDataImmediately("SET CUTTER 1\r\n".getBytes("GB18030"));
                } else {
                    this.writeDataImmediately("SET CUTTER OFF\r\n".getBytes("GB18030"));
                }
                String cls = "CLS\r\n";
                this.writeDataImmediately(cls.getBytes("GB18030"));
                byte[] data = PDFUtils.drawTscPDFLib(mlist.get(j));
                this.writeDataImmediately(data);
                String print = "\r\nPRINT 1\r\n";
                this.writeDataImmediately(print.getBytes("GB18030"));
                if (j != mlist.size() - 1) continue;
                return true;
            }
        }
        return false;
    }

    public static List<Bitmap> ImageCrop(Bitmap bitmap, int photoheight) {
        ArrayList<Bitmap> list = new ArrayList<Bitmap>();
        int last = bitmap.getHeight() % photoheight;
        for (int i = 0; i < bitmap.getHeight() - bitmap.getHeight() % photoheight; i += photoheight) {
            list.add(UsbPort.cutBitmap(bitmap, i, photoheight));
        }
        if (last > 0) {
            Bitmap cp = UsbPort.cutBitmap(bitmap, bitmap.getHeight() - bitmap.getHeight() % photoheight, bitmap.getHeight() % photoheight);
            list.add(cp);
        }
        return list;
    }

    public static Bitmap cutBitmap(Bitmap bitmap, int y, int height) {
        int w = bitmap.getWidth();
        int h = bitmap.getHeight();
        Log.e((String)String.valueOf(w), (String)String.valueOf(h));
        return Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)y, (int)w, (int)height, null, (boolean)false);
    }

    @Override
    public boolean writeDataImmediately(Vector<Byte> sendData) throws IOException {
        if (sendData == null) {
            throw new RuntimeException("data is empty");
        }
        if (this.mmConnection == null) {
            throw new IOException("no connect");
        }
        int offset = 0;
        byte[] data = SDKUtils.convertVectorByteToBytes(sendData);
        List<byte[]> mlist = SDKUtils.getListByteArray(data, this.SPLITE_SIZE);
        int packNum = 0;
        while (packNum < mlist.size()) {
            int ret = this.mmConnection.bulkTransfer(this.mmEndOut, mlist.get(packNum), mlist.get(packNum).length, 1000);
            Log.e((String)TAG, (String)("send result" + ret));
            if (ret > 0) {
                offset += ret;
                ++packNum;
            } else {
                Log.e((String)TAG, (String)"send error");
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (this.isConn) continue;
            Log.e((String)TAG, (String)"Interrupt transmission");
            break;
        }
        sendData.clear();
        mlist.clear();
        if (offset == data.length) {
            Log.e((String)TAG, (String)"send success");
            return true;
        }
        return false;
    }

    @Override
    public boolean writeDataImmediately(byte[] data) throws IOException {
        if (data == null) {
            throw new RuntimeException("data is empty");
        }
        if (this.mmConnection == null) {
            throw new IOException("no connect");
        }
        int offset = 0;
        List<byte[]> mlist = SDKUtils.getListByteArray(data, this.SPLITE_SIZE);
        int packNum = 0;
        while (packNum < mlist.size()) {
            int ret = this.mmConnection.bulkTransfer(this.mmEndOut, mlist.get(packNum), mlist.get(packNum).length, 1000);
            Log.e((String)TAG, (String)("send result" + ret));
            if (ret > 0) {
                offset += ret;
                ++packNum;
            } else {
                Log.e((String)TAG, (String)"send error");
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.isConn) continue;
            Log.e((String)TAG, (String)"Interrupt transmission");
            break;
        }
        mlist.clear();
        if (offset == data.length) {
            Log.e((String)TAG, (String)"send success");
            return true;
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    @Override
    public int getPower() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[DOLOOP]], but top level block is 22[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public String getPrinterModel(Command command) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [15[DOLOOP]], but top level block is 23[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public byte[] getKey() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[DOLOOP]], but top level block is 17[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public int getPrinterStatus(Command command) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [23[DOLOOP]], but top level block is 53[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public boolean getConnectStatus() {
        return this.isConn;
    }

    @Override
    public int readData(byte[] bytes) throws IOException {
        if (this.mmConnection != null) {
            return this.mmConnection.bulkTransfer(this.mmEndIn, bytes, bytes.length, 1000);
        }
        return -1;
    }

    @Override
    public synchronized boolean closePort() {
        Log.e((String)TAG, (String)"close");
        try {
            if (this.mUsbReceiver != null) {
                this.mContext.unregisterReceiver(this.mUsbReceiver);
                this.mUsbReceiver = null;
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("close" + e.getMessage()));
        }
        this.mPrinterDevices = null;
        this.isConn = false;
        if (this.reader != null) {
            this.reader.cancel();
            this.reader.interrupt();
            this.reader = null;
        }
        this.command = null;
        if (this.usbManager != null) {
            this.usbManager = null;
        }
        if (this.mUsbDevice != null) {
            this.mUsbDevice = null;
        }
        if (this.mmIntf != null && this.mmConnection != null) {
            this.mmConnection.releaseInterface(this.mmIntf);
            this.mmConnection.close();
            this.mmConnection = null;
            this.mmIntf = null;
            this.mmEndIn = null;
            this.mmEndOut = null;
            return true;
        }
        return false;
    }

    class IoReader
    extends Thread {
        private boolean isRun = true;

        public void cancel() {
            this.isRun = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (this.isRun) {
                    int len;
                    if (UsbPort.this.mmConnection == null || (len = UsbPort.this.mmConnection.bulkTransfer(UsbPort.this.mmEndIn, UsbPort.this.buffer, UsbPort.this.buffer.length, 2000)) <= 0) continue;
                    Object object = UsbPort.this.lock;
                    synchronized (object) {
                        final byte[] receive = SDKUtils.subBytes(UsbPort.this.buffer, 0, len);
                        UsbPort.this.byteArrayOutputStream.write(receive);
                        UsbPort.this.lock.notifyAll();
                        Thread.sleep(10L);
                        UIThreadManager.onUIThread(new Runnable(){

                            @Override
                            public void run() {
                                UsbPort.this.callbackListener.onReceive(receive);
                            }
                        });
                    }
                }
                return;
            }
            catch (Exception e) {
                if (UsbPort.this.callbackListener == null) return;
                UIThreadManager.onUIThread(new Runnable(){

                    @Override
                    public void run() {
                        LogUtils.e(TAG, "\u65ad\u5f00\u8fde\u63a5");
                        UsbPort.this.callbackListener.onDisconnect();
                    }
                });
            }
        }
    }
}

